/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class AniCanvas
extends Canvas {
    Image[] baseImages = null;
    Image[][] portalImages;
    Image[][] overlayImages;
    Image fimg;
    Image offscreen;
    Graphics grOff = null;
    Graphics[] gr = null;
    int[] portalHeight;
    int[] portalWidth;
    int[] portalX;
    int[] portalY;
    int[] overlayX;
    int[] overlayY;
    int[] windowWidth;
    int[] windowHeight;
    int baseWidth;
    int baseHeight;
    int xMouse = 0;
    int yMouse = 0;
    int xDragStart = 0;
    int yDragStart = 0;
    boolean hasPortals = false;
    boolean hasOverlays = false;
    boolean hasImages = false;
    boolean forceImage = false;
    boolean dragging = false;
    int currentFrame = -1;
    int numOverlays = 0;
    int numPortals = 0;
    Checkbox[] overlay = null;
    boolean doWaitMessage = false;
    String waitMessage;
    String forcedMessage;
    Applet parent;
    int pcount = 0;

    public AniCanvas(Applet applet) {
        this.parent = applet;
    }

    public void setPortals(Image[][] imageArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.portalImages = imageArray;
        this.portalHeight = nArray2;
        this.portalWidth = nArray;
        this.portalX = nArray3;
        this.portalY = nArray4;
        this.numPortals = this.portalImages.length;
        this.hasPortals = true;
        this.repaint();
    }

    public void pleaseWaitMessage(String string) {
        this.waitMessage = string;
        this.doWaitMessage = true;
        this.repaint();
    }

    public void setCurrentFrame(int n) {
        this.currentFrame = n;
        this.repaint();
    }

    public void setForcedImage(Image image, String string) {
        this.fimg = image;
        this.forcedMessage = string;
        this.forceImage = true;
        this.repaint();
    }

    public synchronized void setBaseImages(Image[] imageArray, int n, int n2) {
        this.hasImages = false;
        this.doWaitMessage = false;
        if (this.offscreen != null) {
            this.offscreen.flush();
        }
        if (this.grOff != null) {
            this.grOff.dispose();
        }
        this.baseWidth = n;
        this.baseHeight = n2;
        if (this.xMouse == 0) {
            this.xMouse = this.baseWidth / 2;
            this.yMouse = this.baseHeight / 2;
        }
        this.offscreen = this.createImage(this.baseWidth, this.baseHeight);
        this.grOff = this.offscreen.getGraphics();
        if (this.gr != null) {
            int n3 = 0;
            while (n3 < this.gr.length) {
                this.gr[n3].dispose();
                ++n3;
            }
        }
        this.gr = null;
        this.baseImages = imageArray;
        this.hasImages = true;
        this.paint(this.getGraphics());
    }

    public void setOverlays(Image[][] imageArray, Checkbox[] checkboxArray, int[] nArray, int[] nArray2) {
        this.overlayImages = imageArray;
        this.overlay = checkboxArray;
        this.numOverlays = checkboxArray.length;
        this.hasOverlays = true;
        this.doWaitMessage = false;
        this.overlayX = nArray;
        this.overlayY = nArray2;
    }

    public void setOverlayImages(Image[][] imageArray) {
        this.overlayImages = imageArray;
        this.repaint();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.xDragStart = n;
        this.yDragStart = n2;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.xMouse = n;
        this.yMouse = n2;
        if (this.hasPortals) {
            if (!(this.dragging || Math.abs(this.xDragStart - this.xMouse) <= 2 && Math.abs(this.yDragStart - this.yMouse) <= 2)) {
                this.dragging = true;
            }
            this.repaint();
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.xMouse = n;
        this.yMouse = n2;
        if (!this.dragging) {
            ((AniS)this.parent).gotMouseClick(n, n2, !event.metaDown());
        }
        this.dragging = false;
        return true;
    }

    void paintMyMessage(Graphics graphics, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(string);
        Dimension dimension = this.size();
        graphics.setColor(Color.black);
        graphics.fillRect(dimension.width / 2 - n2 / 2 - 10, dimension.height / 2 - n / 2 - 5, n2 + 20, n + 10);
        graphics.setColor(Color.white);
        graphics.drawString(string, dimension.width / 2 - n2 / 2, dimension.height / 2 + n / 2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        ++this.pcount;
        if (graphics == null) {
            return;
        }
        if (this.forceImage) {
            if (this.fimg != null) {
                graphics.drawImage(this.fimg, 0, 0, this);
            }
            this.forceImage = false;
            this.paintMyMessage(graphics, this.forcedMessage);
            if (!this.doWaitMessage) {
                return;
            }
        }
        if (this.doWaitMessage) {
            this.paintMyMessage(graphics, this.waitMessage);
            return;
        }
        if (!this.hasImages) {
            this.paintMyMessage(graphics, "No images yet");
        } else if (this.currentFrame >= 0) {
            if (!this.hasOverlays && !this.hasPortals) {
                if (this.baseImages[this.currentFrame] != null) {
                    this.grOff.drawImage(this.baseImages[this.currentFrame], 0, 0, this);
                }
            } else {
                int n;
                if (this.baseImages[this.currentFrame] != null) {
                    this.grOff.drawImage(this.baseImages[this.currentFrame], 0, 0, this);
                }
                if (this.hasOverlays) {
                    n = 0;
                    while (n < this.numOverlays) {
                        if (this.overlay[n].getState() && this.overlayImages[n][this.currentFrame] != null) {
                            if (this.overlayX == null) {
                                this.grOff.drawImage(this.overlayImages[n][this.currentFrame], 0, 0, this);
                            } else {
                                this.grOff.drawImage(this.overlayImages[n][this.currentFrame], this.overlayX[n], this.overlayY[n], this);
                            }
                        }
                        ++n;
                    }
                }
                if (this.hasPortals) {
                    if (this.gr == null) {
                        this.gr = new Graphics[this.numPortals];
                        this.windowWidth = new int[this.numPortals];
                        this.windowHeight = new int[this.numPortals];
                        n = 0;
                        while (n < this.numPortals) {
                            this.gr[n] = this.grOff.create(this.portalX[n], this.portalY[n], this.portalWidth[n], this.portalHeight[n]);
                            this.windowWidth[n] = this.portalImages[n][0].getWidth(this.parent);
                            this.windowHeight[n] = this.portalImages[n][0].getHeight(this.parent);
                            ++n;
                        }
                    }
                    n = 0;
                    while (n < this.numPortals) {
                        int n2 = -this.xMouse * 100 * this.windowWidth[n] / this.baseWidth / 100 + this.portalWidth[n] / 2;
                        int n3 = -this.yMouse * 100 * this.windowHeight[n] / this.baseHeight / 100 + this.portalHeight[n] / 2;
                        this.gr[n].setColor(Color.black);
                        if (n2 > 0) {
                            this.gr[n].fillRect(0, 0, n2, this.portalHeight[n]);
                        }
                        if (n3 > 0) {
                            this.gr[n].fillRect(0, 0, this.portalWidth[n], n3);
                        }
                        if (this.portalWidth[n] - n2 > this.windowWidth[n]) {
                            this.gr[n].fillRect(this.windowWidth[n] + n2, 0, this.portalWidth[n] - (this.windowWidth[n] + n2), this.portalHeight[n]);
                        }
                        if (this.portalHeight[n] - n3 > this.windowHeight[n]) {
                            this.gr[n].fillRect(0, this.windowHeight[n] + n3, this.portalWidth[n], this.portalHeight[n] - (this.windowHeight[n] + n3));
                        }
                        this.gr[n].drawImage(this.portalImages[n][this.currentFrame], n2, n3, this);
                        this.gr[n].setColor(Color.black);
                        this.gr[n].drawRect(0, 0, this.portalWidth[n] - 1, this.portalHeight[n] - 1);
                        this.gr[n].drawRect(this.portalWidth[n] / 2 - 3, this.portalHeight[n] / 2 - 3, 7, 7);
                        this.gr[n].setColor(Color.white);
                        this.gr[n].drawRect(this.portalWidth[n] / 2 - 2, this.portalHeight[n] / 2 - 2, 5, 5);
                        ++n;
                    }
                    this.grOff.setColor(Color.white);
                    this.grOff.drawRect(this.xMouse - 3, this.yMouse - 3, 7, 7);
                    this.grOff.setColor(Color.black);
                    this.grOff.drawRect(this.xMouse - 2, this.yMouse - 2, 5, 5);
                }
            }
            graphics.drawImage(this.offscreen, 0, 0, this);
        }
    }
}

