/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class Enhance
extends RGBImageFilter {
    private DataInputStream dis = null;
    private Vector names = new Vector();
    private Vector tables = new Vector();
    private Vector list = new Vector();
    private int[] myRGBTab;

    public Enhance(String string) throws Exception {
        try {
            this.dis = new DataInputStream(new FileInputStream(string));
            this.buildList(this.dis);
        }
        catch (Exception exception) {
            throw new Exception("URL for enh.tab not found");
        }
    }

    public Enhance(URL uRL) throws Exception {
        try {
            this.dis = new DataInputStream(uRL.openStream());
            this.buildList(this.dis);
        }
        catch (Exception exception) {
            throw new Exception("URL for enh.tab not found");
        }
    }

    private void buildList(DataInputStream dataInputStream) {
        this.myRGBTab = new int[256];
        this.canFilterIndexColorModel = true;
        try {
            String string;
            while ((string = dataInputStream.readLine()) != null) {
                int n = string.indexOf("#");
                if (n == 0 || string.length() < 2) continue;
                if (n > 0) {
                    string = string.substring(0, n);
                }
                if (string.startsWith("*")) {
                    this.names.addElement(string.substring(1));
                    this.list = new Vector();
                    this.tables.addElement(this.list);
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                if (stringTokenizer.countTokens() != 8) continue;
                int[] nArray = new int[8];
                int n2 = 0;
                while (n2 < 8) {
                    nArray[n2] = Integer.parseInt(stringTokenizer.nextToken().trim());
                    ++n2;
                }
                this.list.addElement(nArray);
            }
        }
        catch (Exception exception) {
            System.out.println("Ex reading:" + exception);
        }
    }

    public String[] getNames() {
        int n = this.names.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.names.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public int[] getTable(int n) {
        Vector vector = (Vector)this.tables.elementAt(n);
        int n2 = 0;
        while (n2 < 256) {
            this.myRGBTab[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            int[] nArray = (int[])vector.elementAt(n3);
            int n4 = nArray[1] - nArray[0];
            float f = nArray[2];
            float f2 = nArray[3];
            float f3 = (f2 - f) / (float)n4;
            float f4 = nArray[4];
            float f5 = nArray[5];
            float f6 = (f5 - f4) / (float)n4;
            float f7 = nArray[6];
            float f8 = nArray[7];
            float f9 = (f8 - f7) / (float)n4;
            int n5 = nArray[0];
            while (n5 <= nArray[1]) {
                this.myRGBTab[n5] = (int)f << 16 | (int)f4 << 8 | (int)f7;
                f += f3;
                f4 += f6;
                f7 += f9;
                ++n5;
            }
            ++n3;
        }
        return this.myRGBTab;
    }

    public Image[] EnhanceImages(Applet applet, Image[] imageArray, int n) {
        this.getTable(n);
        MediaTracker mediaTracker = new MediaTracker(applet);
        int n2 = imageArray.length;
        if (n2 < 1) {
            return null;
        }
        Image[] imageArray2 = new Image[n2];
        int n3 = 0;
        while (n3 < n2) {
            try {
                FilteredImageSource filteredImageSource = new FilteredImageSource(imageArray[n3].getSource(), this);
                imageArray2[n3] = applet.createImage(filteredImageSource);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                imageArray2[n3] = null;
            }
            mediaTracker.addImage(imageArray2[n3], 0);
            ++n3;
        }
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return imageArray2;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = (n3 & 0xFF0000) >> 16;
        int n5 = (n3 & 0xFF00) >> 8;
        int n6 = n3 & 0xFF;
        if (Math.abs(n4 - n5) < 5 && Math.abs(n5 - n6) < 5) {
            return n3 & 0xFF000000 | this.myRGBTab[n4];
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        String string = "enh.tab";
        System.out.println("Enh test");
        try {
            Enhance enhance = new Enhance(string);
            String[] stringArray2 = enhance.getNames();
            int n = 0;
            while (n < stringArray2.length) {
                System.out.println("i=" + n + "  name=" + stringArray2[n]);
                int[] nArray = enhance.getTable(n);
                int n2 = 0;
                while (n2 < 256) {
                    int n3 = (nArray[n2] >> 16) % 256;
                    int n4 = (nArray[n2] >> 8) % 256;
                    int n5 = nArray[n2] % 256;
                    System.out.println("k=" + n2 + "  r/g/b=" + n3 + " " + n4 + " " + n5);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("####  " + exception);
        }
    }
}

