/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class RotatorThing
extends Canvas {
    Image rotator;
    Image rotBuffer;
    int width = 80;
    int height = 40;
    int diameter = 20;
    Dimension dim = new Dimension(this.width, this.height);
    boolean init = true;
    int xm;
    int ym;
    int xc;
    int yc;
    Color backcolor;
    Color forecolor;
    String[] labels;
    double angle;
    Font labelFont;
    FontMetrics fm;
    int fmHeight;
    double[] xoff;
    double[] yoff;
    int oldWhich = 0;
    int numItems = 0;
    AniS parent;
    boolean mouseActive = false;

    public RotatorThing(AniS aniS, String[] stringArray, int n, Color color, Color color2) {
        this.backcolor = color;
        this.forecolor = color2;
        this.xc = this.width / 2;
        this.yc = this.height / 2;
        this.labels = null;
        this.angle = 0.0;
        this.parent = aniS;
        this.labelFont = new Font("sans", 0, 10);
        this.fm = this.getFontMetrics(this.labelFont);
        this.fmHeight = this.fm.getMaxAscent() + this.fm.getMaxDescent();
        this.numItems = n;
        this.labels = stringArray;
        if (this.numItems <= 0) {
            this.numItems = this.labels.length;
        }
        this.xoff = new double[]{-0.5, 0.0, 0.05, 0.0, -0.5, -1.0, -1.1, -1.0};
        this.yoff = new double[]{-0.1, 0.0, 0.35, 0.6, 0.65, 0.6, 0.35, 0.0};
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public Dimension getMaximumSize() {
        return this.dim;
    }

    public Dimension getMinimumSize() {
        return this.dim;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 506 || event.id == 501) {
            int n;
            this.angle = Math.atan2(event.y - this.yc, event.x - this.xc) + 1.571;
            if (this.angle < 0.0) {
                this.angle += 6.28318;
            }
            if ((n = (int)Math.round(this.angle / 6.28318 * (double)this.numItems)) == this.numItems) {
                n = 0;
            }
            if (n != this.oldWhich) {
                this.parent.setCurrentFrame(true, n);
                this.oldWhich = n;
            } else {
                this.repaint();
            }
            this.mouseActive = true;
            return true;
        }
        if (event.id == 502) {
            this.mouseActive = false;
            return true;
        }
        return super.handleEvent(event);
    }

    public void setCurrentFrame(int n) {
        if (this.mouseActive) {
            return;
        }
        if (this.numItems > 0) {
            this.angle = 6.28318 * (double)n / (double)this.numItems;
        }
        this.repaint();
    }

    public void setLabels(String[] stringArray) {
        this.labels = stringArray;
        this.init = true;
        this.repaint();
    }

    public void setNumFrames(int n) {
        this.numItems = n;
        if (this.numItems <= 0) {
            this.numItems = this.labels.length;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Graphics graphics2;
        if (this.init) {
            this.rotator = this.createImage(this.width, this.height);
            this.rotBuffer = this.createImage(this.width, this.height);
            graphics2 = this.rotator.getGraphics();
            graphics2.setColor(this.backcolor);
            graphics2.fillOval(this.xc - this.diameter / 2, this.yc - this.diameter / 2, this.diameter, this.diameter);
            this.init = false;
            graphics2.setFont(this.labelFont);
            double d = this.diameter / 2;
            if (this.labels == null) {
                return;
            }
            int n = 0;
            while (n < this.labels.length) {
                double d2 = (double)n * 360.0 * 0.0174533 / (double)this.labels.length;
                int n2 = this.xc + (int)Math.round(d * Math.sin(d2));
                int n3 = this.yc - (int)Math.round(d * Math.cos(d2));
                int n4 = this.fm.stringWidth(this.labels[n]);
                int n5 = (int)Math.round((double)n * 8.0 / (double)this.labels.length);
                int n6 = n2 + (int)Math.round((double)n4 * this.xoff[n5]);
                int n7 = n3 + (int)Math.round((double)this.fmHeight * this.yoff[n5]);
                graphics2.drawString(this.labels[n], n6, n7);
                ++n;
            }
            graphics2.dispose();
        }
        graphics2 = this.rotBuffer.getGraphics();
        graphics2.drawImage(this.rotator, 0, 0, this);
        graphics2.setColor(this.forecolor);
        int n = this.xc + (int)Math.round((double)this.diameter * Math.sin(this.angle));
        int n8 = this.yc - (int)Math.round((double)this.diameter * Math.cos(this.angle));
        graphics2.drawLine(this.xc, this.yc, n, n8);
        graphics.drawImage(this.rotBuffer, 0, 0, this);
        graphics2.dispose();
    }
}

